﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="VeteransAffairs.Registries.BusinessManager" %>
<%@ Import Namespace="VeteransAffairs.Registries.Business.Utilities" %>

<script runat="server">

    void Application_Start(object sender, EventArgs e) 
    {
        // Code that runs on application startup

    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //  Code that runs on application shutdown

    }

    void Application_Error(object sender, EventArgs e)
    {
        //ExceptionPolicy.HandleException(Server.GetLastError().GetBaseException(), "Global");

        try
        {
            Exception ex = Server.GetLastError();
            Logging.WriteLogToFile("Application_Error1: " + ex.ToString());
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Application_Error2: " + ex.ToString());
        }
        
    }

    void Session_Start(object sender, EventArgs e) 
    {
        try
        {
            // Code that runs when a new session is started
            string userId = HttpContext.Current.User.Identity.Name; // this.User.Identity.Name;

            Logging.WriteLogToFile("LOGON: " + userId);
        }
        catch (Exception ex)
        {
            // do nothing
        }
    }

    void Session_End(object sender, EventArgs e) 
    {
        // Code that runs when a session ends. 
        // Note: The Session_End event is raised only when the sessionstate mode
        // is set to InProc in the Web.config file. If session mode is set to StateServer 
        // or SQLServer, the event is not raised.
        
        string userId = HttpContext.Current.User.Identity.Name; // this.User.Identity.Name;

        Logging.WriteLogToFile("LOGOUT: " + userId);
    }
    
    void WindowsAuthentication_OnAuthenticate(object Source, WindowsAuthenticationEventArgs e)
    {
        //Note that since IIS has already performed 
        //authentication, the provided identity is used.
        
    }    

    void Application_AuthenticateRequest(object sender, EventArgs e)
    {
        //// Fires upon attempting to authenticate the user
        
    }

    void Application_PostAuthenticateRequest(object sender, EventArgs e)
    {
        // Fires when the user has authenticated
        if (HttpContext.Current.Request.Url.PathAndQuery.IndexOf(".as") > 0)
        {
            if (Context.Request.IsAuthenticated)
            {
                string key = "RegistryName";
                string RegistryName = "";

                Helpers.GetConfigEntry("Registry");

                if (!CacheHelper.Get(key, out RegistryName))
                {
                    RegistryName = Helpers.GetConfigEntry("Registry");
                    CacheHelper.Add(RegistryName, key);
                }

                UserAccountManager uam;

                string userId = HttpContext.Current.User.Identity.Name; // this.User.Identity.Name;
                int ind = userId.IndexOf("\\") + 1;
                userId = userId.Substring(ind, userId.Length - ind);
                uam = new UserAccountManager(userId, RegistryName);

                HttpContext.Current.User = uam;
                System.Threading.Thread.CurrentPrincipal = HttpContext.Current.User;
            }
            else
            {
                Response.Write("Not authenticated.");
                Response.Write("<br>");
                Response.Write(HttpContext.Current.Request.Url.PathAndQuery);
                Response.End();
            }
        }    
    }

   

</script>
